using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Summary description for DlgLockWarning.
	/// </summary>
	public class DlgLockWarning : gov.va.med.vbecs.GUI.VbecsBaseForm
	{

		private int _countdownSeconds = 59;

		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Timer timer1;
		private System.Windows.Forms.Label lblCountdown;
		private System.Windows.Forms.Label label2;
		private System.ComponentModel.IContainer components;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="remainingTime"></param>
		/// <param name="lockFunctionId"></param>
		public DlgLockWarning(int remainingTime, Common.LockFunctions lockFunctionId)
		{
			InitializeComponent();

			if(remainingTime < 50)
			{
				this._countdownSeconds = remainingTime;
			}

			this.DialogResult = DialogResult.Cancel;
			this.timer1.Enabled = true;

			System.Data.DataRow drTitle = BOL.ReferenceData.GetLockFunction(lockFunctionId);

			this.vbecsLogo1.Title = drTitle[Common.VbecsTables.VbecsLockFunction.FunctionDescription].ToString();
			
			this.lblCountdown.Text = this._countdownSeconds.ToString();
			this.lblCountdown.Refresh();

		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.label1 = new System.Windows.Forms.Label();
			this.button1 = new System.Windows.Forms.Button();
			this.timer1 = new System.Windows.Forms.Timer(this.components);
			this.lblCountdown = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(330, 30);
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 159);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(8, 40);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(320, 40);
			this.label1.TabIndex = 0;
			this.label1.Text = "You are approaching the maximum allowed inactivity time.  The data you currently " +
				"have locked will be released in...";
			// 
			// button1
			// 
			this.button1.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.button1.Location = new System.Drawing.Point(72, 136);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(184, 32);
			this.button1.TabIndex = 1;
			this.button1.Text = "&Continue";
			// 
			// timer1
			// 
			this.timer1.Interval = 950;
			this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
			// 
			// lblCountdown
			// 
			this.lblCountdown.Font = new System.Drawing.Font("Microsoft Sans Serif", 22F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblCountdown.Location = new System.Drawing.Point(120, 88);
			this.lblCountdown.Name = "lblCountdown";
			this.lblCountdown.Size = new System.Drawing.Size(64, 32);
			this.lblCountdown.TabIndex = 2;
			this.lblCountdown.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			this.lblCountdown.Click += new System.EventHandler(this.lblCountdown_Click);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(184, 104);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(120, 24);
			this.label2.TabIndex = 3;
			this.label2.Text = "seconds";
			// 
			// DlgLockWarning
			// 
			this.AcceptButton = this.button1;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(330, 175);
			this.ControlBox = false;
			this.Controls.Add(this.label2);
			this.Controls.Add(this.lblCountdown);
			this.Controls.Add(this.button1);
			this.Controls.Add(this.label1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximumSize = new System.Drawing.Size(336, 200);
			this.MinimumSize = new System.Drawing.Size(336, 200);
			this.Name = "DlgLockWarning";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.ShowInTaskbar = true;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "VBECS - Inactivity Warning";
			this.TopMost = true;
			this.Controls.SetChildIndex(this.label1, 0);
			this.Controls.SetChildIndex(this.button1, 0);
			this.Controls.SetChildIndex(this.lblCountdown, 0);
			this.Controls.SetChildIndex(this.label2, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.ResumeLayout(false);

		}
		#endregion

		private void timer1_Tick(object sender, System.EventArgs e)
		{
			this._countdownSeconds--;

			this.lblCountdown.Text = this._countdownSeconds.ToString();
			this.lblCountdown.Refresh();

			if(this._countdownSeconds == 0)
			{
				this.timer1.Enabled = false;
				this.Close();
			}
		}

		private void lblCountdown_Click(object sender, System.EventArgs e)
		{
		
		}
	}
}
